{
        HAMEG GmbH

		RS232 -
		Sample program for communicating with interface HO79
		Interrupt 14H used
		The sample program expects a RS232 input buffer to
		  read all data from the interface
		RS232-R1.EXE is a memory resident program which provides
		  this buffer. Call this program once after the PC boots.
		  Thereafter access to the buffered data is enabled via
		  the BIOS call.
		  When using COM1 call: RS232-R1
		  when using COM2 call: RS232-R2
}

PROGRAM RS232;

USES
    DOS,
    Crt;

CONST
{	Tastencodes fr readkey }
	 ESC    = 27;
	 F1     = $3B;
	 F2     = $3C;
	 F3     = $3D;
	 F4     = $3E;
	 F10    = $44;

	 COM1 = 0;                         { serial port 1 }
	 COM2 = 1;                         { serial port 2 }

		 { Commands for BIOS call Int 14h }
	 INIT    = 0;
	 SEND    = 1;
	 RECEIVE = 2;
	 STATUS  = 3;

{ Parameters for serial interface }
	 BD9600  = $E0;                    { Baud rate }
	 BD4800  = $C0;
	 BD2400  = $A0;
	 BD1200  = $80;
	 EVEN    = $18;                    { Parity }
	 ODD     = $08;
	 NONE    = $00;
	 STOP_1  = $00;                    { Stop bits }
	 STOP_2  = $04;
	 BITS_8  = $03;                    { Data bits }
	 BITS_7  = $02;

{ Commands for interface HO79 }
     ID  = 'ID?'+#13;
     DIG = 'DIG'+#13;
     GET = 'GET'+#13;

{ Flag for program termination }
     stop     : boolean = false;


TYPE
  win = RECORD
  l,t,r,b : byte;              { l:left; t:top; r:right; b:bottom }
  x,y     : byte;              { x:Cursor-x-Position, y:Cursor-y-P. }
  c, bg   : byte;              { c:Color; bg:Background }
  END;

CONST
{ Window setup data }

  Header_win : win =
  (l:1;t:1;r:80;b:1;       x:1;y:1;     c:YELLOW; bg:CYAN);

  Fkt_win : win =
  (l:1;t:25;r:80;b:25;     x:1;y:1;     c:YELLOW; bg:CYAN);

  Recv_win : win =
  (l:1;t:3;r:80;b:20;      x:1;y:1;     c:WHITE; bg:BLUE);

  Send_win : win =
  (l:1;t:22;r:80;b:23;     x:1;y:1;     c:LIGHTRED; bg:BLUE);

VAR
   data,                                { Transferbyte for BIOS call  }
   COM_status,                          { Line status after BIOS call }
   Port         : byte;                 { Interfcae in use            }
   Key          : char;                 { Code of readkey             }
   pos          : byte;                 { character position for cmd  }
   cmd          : string;               { Command for interface       }


{  }

{
  bioscom

  Serial communication using DIOS call 14h
  Three functions (cmd) are supported:
		INIT, SEND, and RECEIVE

  INIT:
	Setup of baud rate, parity bit, stop bits, and number of bits
  SEND :
	Transmit a byte (ch)
  RECEIVE :
	Receive a byte (ch)

	The function returns the line control status

  Parameters :
		cmd  - function call
		ch   - transfer byte
		port - serial interface COM1 oder COM2

  Status :
	bit 7 : timeout
		6 : trans shift reg empty
		5 : trans holding reg empty
		4 : bread detect
		3 : framing error
		2 : parity error
		1 : overrun error
		0 : data ready status
}

FUNCTION bioscom (cmd : byte; VAR ch : byte; port : byte): byte;
var
  regs : Registers;
   BEGIN
   regs.ah := cmd;
   regs.dx := port;
   regs.al := ch;
   intr ($14, regs);
   IF cmd = RECEIVE THEN ch := regs.al;
   bioscom := regs.ah;
   END;


{  }

{
   Set_Window

   Windos settings:
   window corners, cursor positions, and window colors
}

PROCEDURE Set_Window (w : win);
  BEGIN
   WITH w DO
     BEGIN
     window (l,t,r,b);
     textcolor(c);
     textbackground(bg);
     gotoxy (x,y);
     END;
  END;


{  }
{
	Short program description :
	Display title and function key settings
	Main loop with three items
	1. Data transfer, activated by keyboard inputs
	   1.1 ASCII key:    transmit character
	   1.2 Function key: transmit command
	2. Receive data and display data in readable format
	3. Terminate program by pushing F10 or ESC

}
  BEGIN
  textcolor (WHITE);
  textbackground(BLUE);
  clrscr;

  { Initialisation of serial interface COM1 }
  Port:=COM1;
  data := BD9600 or NONE or STOP_1 or BITS_8;
  COM_status := bioscom(INIT, data, Port);

  { set binary format ! }
  cmd := 'FRM 0'+#13;
  FOR pos := 1 TO length(cmd) DO BEGIN
    { Transmit character }
    data :=ord(cmd[pos]);
    COM_status := bioscom (SEND, data, Port);
    END;

  Set_Window (Header_Win);
  clreol;
  write(' PASCAL - DEMO         Interface HO79        HAMEG GmbH Software Support 1991 ');

  Set_Window (Fkt_Win);
  clreol;
  write('  F1-ID?   F2-DIG   F3-GET                                            F10-EXIT');

  { Initialize RECEIVE window }
  Set_Window (Recv_win);
  REPEAT

    { Testen ob Daten im Empfangspuffer sind }
    COM_status := bioscom(RECEIVE, data, Port);
    IF (COM_status AND $80) = 0   { entweder TIMEOUT oder Daten erhalten }
      THEN write (chr(data));

	{ Check if data in input buffer }
    IF keypressed
      THEN BEGIN
	  { Transmit character or command! }
      Key := readkey;
      IF Key = #0 THEN
		BEGIN       { Function keys }
        Key := ReadKey;
		{ cmd (transmit buffer) command asignment }
        Case ord(Key) OF
          F1 : cmd := ID;
          F2 : cmd := DIG;
          F3 : cmd := GET;
          F10 : stop := true;
          END;
        END
		ELSE BEGIN      { character }
        stop := ESC = ord(Key);
        IF not stop
          THEN BEGIN
		  { cmd (transmit buffer) character asignment }
          cmd := Key;
          END;
        END;
	  { If transmit buffer not empty: display data and transmit }
      IF cmd <> ''
        THEN BEGIN
		{ Save actual cursor positions and open Tx window}
        Recv_win.x := wherex;
        Recv_win.y := wherey;
        Set_Window (Send_win);
        FOR pos := 1 TO length(cmd) DO
          BEGIN
		  { Transmit character }
          data :=ord(cmd[pos]);
	  COM_status := bioscom (SEND, data, Port);
		  { Display character }
          write (chr(data));
          if (ord(data)=13)
            THEN BEGIN
            gotoxy (1,1); clreol;
            END;
	  END;
		{ Save actual cursor positions and open Tx window}
        Send_Win.x := wherex; Send_Win.y := wherey;
        Set_Window (Recv_win);
	END;
      END;
    UNTIL (stop);
  END.
